/*
 * Decompiled with CFR 0.152.
 */
package org.autoplot;

import java.awt.AWTPermission;
import java.io.File;
import java.io.FilePermission;
import java.net.InetAddress;
import java.net.NetPermission;
import java.net.URLPermission;
import java.nio.file.LinkPermission;
import java.security.AllPermission;
import java.security.Permission;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.PropertyPermission;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.logging.LoggingPermission;
import javax.sound.sampled.AudioPermission;
import org.autoplot.datasource.AutoplotSettings;
import org.autoplot.hapi.HapiDataSource;
import org.das2.util.LoggerManager;

public final class Sandbox {
    private static final Logger logger = LoggerManager.getLogger((String)"autoplot.security");
    private static SecurityManager instance = null;

    public static synchronized SecurityManager getSandboxManager() {
        if (instance == null) {
            instance = Sandbox.createSandboxManager();
        }
        return instance;
    }

    private static SecurityManager createSandboxManager() {
        boolean linux = System.getProperty("os.name").equals("Linux");
        boolean windows = System.getProperty("os.name").startsWith("Windows");
        boolean notWindows = !windows;
        ArrayList<String> readWriteList = new ArrayList<String>();
        readWriteList.add(AutoplotSettings.settings().resolveProperty("autoplotData"));
        if (linux) {
            readWriteList.add(System.getProperty("user.home") + "/.java/.userPrefs");
        }
        if (notWindows) {
            readWriteList.add("/tmp");
        } else {
            readWriteList.add(System.getProperty("user.home") + "\\AppData\\Local\\Temp");
        }
        String hapiData = HapiDataSource.getHapiCache();
        readWriteList.add(hapiData);
        ArrayList<String> readOnlyList = new ArrayList<String>(readWriteList);
        String path = System.getProperty("java.class.path");
        if (!windows) {
            readOnlyList.addAll(Arrays.asList(path.split(":")));
        } else {
            readOnlyList.addAll(Arrays.asList(path.split(";")));
        }
        readOnlyList.add(System.getProperty("java.home"));
        if (linux) {
            readOnlyList.add("/usr/share/fonts/");
            readOnlyList.add(System.getProperty("user.home") + "/.fonts/");
        }
        readOnlyList.add("__classpath__");
        if (windows) {
            readOnlyList.add(System.getProperty("user.home") + "\\.das2rc");
        } else {
            readOnlyList.add(System.getProperty("user.home") + "/.das2rc");
        }
        final List f_rwOkayHome = Collections.unmodifiableList(readWriteList);
        final List f_roOkayHome = Collections.unmodifiableList(readOnlyList);
        HashSet<String> roBlacklist = new HashSet<String>();
        if (notWindows) {
            roBlacklist.add("/etc");
            roBlacklist.add("/sys");
            roBlacklist.add("/boot");
            roBlacklist.add("/proc");
            roBlacklist.add("/dev");
        }
        final Set f_roBlacklist = Collections.unmodifiableSet(roBlacklist);
        HashSet<String> okayProps = new HashSet<String>();
        okayProps.add("sun.awt.disablegrab");
        okayProps.add("java.awt.headless");
        okayProps.add("useHugeScatter");
        okayProps.add("rangeChecking");
        okayProps.add("sun.arch.data.model");
        okayProps.add("line.separator");
        okayProps.add("os.name");
        okayProps.add("os.arch");
        okayProps.add("user.dir");
        okayProps.add("user.home");
        okayProps.add("java.home");
        okayProps.add("java.version");
        okayProps.add("proxyHost");
        okayProps.add("socksProxyHost");
        okayProps.add("https.proxyHost");
        okayProps.add("http.agent");
        okayProps.add("enableReferenceCache");
        okayProps.add("sun.awt.noerasebackground");
        okayProps.add("HAPI_DATA");
        okayProps.add("AUTOPLOT_DATA");
        okayProps.add("cdawebHttps");
        okayProps.add("python.cachedir");
        final Set f_okayProps = Collections.unmodifiableSet(okayProps);
        HashSet<String> okayPermissions = new HashSet<String>();
        okayPermissions.add("accessClipboard");
        okayPermissions.add("AWTPermission");
        okayPermissions.add("suppressAccessChecks");
        okayPermissions.add("accessDeclaredMembers");
        final Set f_okayPermissions = Collections.unmodifiableSet(okayPermissions);
        HashSet<String> okaySecurityAccessTargets = new HashSet<String>();
        okaySecurityAccessTargets.add("putProviderProperty.SunRsaSign");
        okaySecurityAccessTargets.add("putProviderProperty.SUN");
        okaySecurityAccessTargets.add("putProviderProperty.Sun");
        okaySecurityAccessTargets.add("putProviderProperty.XMLD");
        final Set f_okaySecurityAccessTargets = Collections.unmodifiableSet(okaySecurityAccessTargets);
        SecurityManager limitedSecurityManager = new SecurityManager(){

            @Override
            public ThreadGroup getThreadGroup() {
                return super.getThreadGroup();
            }

            @Override
            public void checkSecurityAccess(String target) {
                for (String s : f_okaySecurityAccessTargets) {
                    if (!target.startsWith(s)) continue;
                    logger.log(Level.FINER, "checkSecurityAccess({0})", s);
                    return;
                }
                logger.log(Level.FINE, "checkSecurityAccess({0})", target);
            }

            @Override
            public void checkPackageDefinition(String pkg) {
                logger.log(Level.FINE, "checkPackageDefinition({0})", pkg);
            }

            @Override
            public void checkPropertyAccess(String key) {
                if (f_okayProps.contains(key)) {
                    logger.log(Level.FINER, "checkPropertyAccess({0}) OK", key);
                } else {
                    logger.log(Level.FINER, "checkPropertyAccess({0}) (All properties are okay)", key);
                }
            }

            @Override
            public void checkMulticast(InetAddress maddr) {
                logger.log(Level.FINE, "checkMulticast({0})", maddr);
            }

            @Override
            public void checkAccept(String host, int port) {
                logger.log(Level.FINER, "checkAccept({0}, {1})", new Object[]{host, port});
            }

            @Override
            public void checkListen(int port) {
                logger.log(Level.FINER, "checkListen({0})", port);
            }

            @Override
            public void checkConnect(String host, int port, Object context) {
                logger.log(Level.FINER, "checkConnect({0}, {1}, {2}) NET", new Object[]{host, port, context});
            }

            @Override
            public void checkConnect(String host, int port) {
                logger.log(Level.FINER, "checkConnect({0}, {1}) NET", new Object[]{host, port});
            }

            private boolean whitelistFile(String file) {
                if (file.contains("..")) {
                    return false;
                }
                return f_rwOkayHome.stream().anyMatch(s -> file.startsWith((String)s));
            }

            private boolean readOnlyWhitelistFile(String file) {
                if (file.contains("..")) {
                    return false;
                }
                return f_roOkayHome.stream().anyMatch(s -> file.startsWith((String)s));
            }

            private boolean readOnlyBlacklistFile(String file) {
                if (file.contains("..")) {
                    return false;
                }
                return f_roBlacklist.stream().anyMatch(s -> file.startsWith((String)s));
            }

            private String getCanonicalFile(String file) {
                return new File(file).getAbsolutePath();
            }

            @Override
            public void checkDelete(String file) {
                if (!this.whitelistFile(file = this.getCanonicalFile(file))) {
                    throw new SecurityException("sandbox disallows delete of " + file);
                }
                logger.log(Level.FINER, "checkDelete({0}) WHITELIST", file);
            }

            @Override
            public void checkWrite(String file) {
                if (!this.whitelistFile(file = this.getCanonicalFile(file))) {
                    throw new SecurityException("sandbox disallows write of " + file);
                }
                logger.log(Level.FINER, "checkWrite({0}) WHITELIST", file);
            }

            @Override
            public void checkRead(String file, Object context) {
                if (this.readOnlyWhitelistFile(file = this.getCanonicalFile(file))) {
                    logger.log(Level.FINER, "checkRead({0}, {1}) WHITELIST", new Object[]{file, context});
                } else {
                    if (this.readOnlyBlacklistFile(file)) {
                        throw new SecurityException(String.format("sandbox disallows read from " + file, new Object[0]));
                    }
                    logger.log(Level.FINER, "checkRead({0}, {1})", new Object[]{file, context});
                    logger.log(Level.FINE, "checkRead({0}, {1})", new Object[]{file, context});
                }
            }

            @Override
            public void checkRead(String file) {
                if (this.readOnlyWhitelistFile(file = this.getCanonicalFile(file))) {
                    logger.log(Level.FINER, "checkRead({0}) WHITELIST", file);
                } else {
                    if (this.readOnlyBlacklistFile(file)) {
                        throw new SecurityException(String.format("checkRead( (%s) BLACKLIST", file));
                    }
                    logger.log(Level.FINER, "checkRead({0})", file);
                }
            }

            @Override
            public void checkPermission(Permission perm, Object context) {
                logger.log(Level.FINE, "checkPermission( {0}, {1})", new Object[]{perm.getName(), context});
                this.checkPermission(perm);
            }

            @Override
            public void checkPermission(Permission perm) {
                if (perm instanceof PropertyPermission) {
                    String name = perm.getName();
                    String actions = perm.getActions();
                    if (f_okayProps.contains(name)) {
                        logger.log(Level.FINER, "checkPermission( PropertyPermission {0} ) OK", new Object[]{name});
                    } else if ("*".equals(name) && "read,write".equals(actions)) {
                        logger.log(Level.FINER, "checkPermission( PropertyPermission * read,write ) okay for Beans", new Object[]{name});
                    } else if ("read".equals(actions)) {
                        logger.log(Level.FINER, "checkPermission( PropertyPermission read ) OK");
                    } else {
                        logger.log(Level.FINE, "checkPermission( PropertyPermission {0} )", new Object[]{name});
                    }
                } else if (perm instanceof LoggingPermission) {
                    logger.log(Level.FINER, "checkPermission( LoggingPermission {0} ) OK", new Object[]{perm});
                } else if (perm instanceof AWTPermission) {
                    logger.log(Level.FINER, "checkPermission( AWTPermission {0} ) OK", new Object[]{perm});
                } else if (perm instanceof URLPermission) {
                    logger.log(Level.FINER, "checkPermission( URLPermission {0} ) OK", new Object[]{perm});
                } else if (perm instanceof FilePermission) {
                    String name = perm.getName();
                    String action = perm.getActions();
                    if ("read".equals(action)) {
                        String file = name;
                        if (this.readOnlyWhitelistFile(file)) {
                            logger.log(Level.FINER, "checkPermission( FilePermission({0}) WHITELIST", file);
                        } else {
                            if (this.readOnlyBlacklistFile(file)) {
                                throw new SecurityException(String.format("checkPermission( FilePermission(%s) BLACKLIST", file));
                            }
                            logger.log(Level.FINER, "checkPermission( FilePermission({0})", file);
                        }
                    } else {
                        super.checkPermission(perm);
                    }
                } else {
                    if (perm instanceof LinkPermission) {
                        throw new SecurityException(String.format("sandbox disallows making filesystem links.", new Object[0]));
                    }
                    if (perm instanceof RuntimePermission) {
                        String name = perm.getName();
                        logger.log(Level.FINER, "checkPermission( RuntimePermission {0} ) OK", new Object[]{name});
                    } else if (perm instanceof AllPermission) {
                        logger.log(Level.FINER, "checkPermission( AllPermission ) FileSystem calls so OK");
                    } else if (perm instanceof NetPermission) {
                        logger.log(Level.FINER, "checkPermission( NetPermission ) OK, but this should be studied more.");
                    } else {
                        if (perm instanceof AudioPermission) {
                            throw new SecurityException(String.format("checkPermission( AudioPermission(%s) )", perm.getName()));
                        }
                        String name = perm.getName();
                        if (f_okayPermissions.contains(name)) {
                            logger.log(Level.FINER, "checkPermission( {0} ) OK", new Object[]{name});
                        } else if (name.startsWith("getProperty")) {
                            logger.log(Level.FINER, "checkPermission( {0} ) OK getProperty", new Object[]{name});
                        } else {
                            throw new SecurityException(String.format("unrecognized permission: (%s)", name));
                        }
                    }
                }
            }
        };
        return limitedSecurityManager;
    }

    public static void enterSandbox() {
        System.setSecurityManager(Sandbox.getSandboxManager());
    }
}

